//___________________________________________________________________
//___________________________________________________________________
//  Copyright : 2021 BY HOLTEK SEMICONDUCTOR INC
//  File Name : ANALOG.c
// Description: include DAC PGA1 PGA2 SCF Current Charge Pump
//Targer Board: 
//   MCU      : BH67F2265
//   Author   : ming
//   Date     : 20210308
//   Version  : V00
//   History  :
//___________________________________________________________________
//___________________________________________________________________
#include "common.h"



u8	gu8v_bat_time;


/********************************************************************
Function: PGA1_INIT
INPUT	:pga1 Gain 1 and gain 2 set
OUTPUT	:
NOTE	:Gain = (1 + lu8v_gain2 / 32)*lu8v_gain1
		lu8v_gain1:Pgac1_gain1_8、Pgac1_gain1_16、Pgac1_gain1_32Pgac1_gain1_64
		lu8v_gain2:0-31
********************************************************************/
void fun_PGA1_INIT(u8 lu8v_gain1,u8 lu8v_gain2)
{
	_pgac0 = Pgac0_Default+lu8v_gain1;
	_pgac1 = Pgac1_Default+lu8v_gain2;
}
/********************************************************************
Function: PGA2_INIT
INPUT	:
OUTPUT	:
NOTE	:
********************************************************************/
void fun_PGA2_INIT()
{
	_pgac2 = Pgac2_Default;

}

/********************************************************************
Function: SCF_INIT
INPUT	:lu8v_scf_gain
OUTPUT	:
NOTE	:0-63  scf Gain = 56 + 4 × lu8v_scf_gain
********************************************************************/
void fun_SCF_INIT(u8 lu8v_scf_gain)
{
	_scfc0 = Scfc0_Default+lu8v_scf_gain;
	_scfc1 = Scfc1_Default;
	_scfckd = Scfckd_Default;
	_pgac3 &= 0b11100000;	
	_pgac3 |= PGAC3_Default;	
	
}

/********************************************************************
Function: CCurrent_INIT
INPUT	:
OUTPUT	:
NOTE	:
********************************************************************/
void fun_CCurrent_INIT()
{
	_ccvrefc = Ccvrefc_Default;

}




/********************************************************************
Function: fun_En_Analog_power
INPUT	:
OUTPUT	:
NOTE	:
********************************************************************/
void fun_En_Analog_power()
{
	//ldo enable 
	_regc = 0x03;//3.3v
//	_regc = 0x01;//vdd
	//pga enable 
	_pgaen = 1;
	//恆流源使能
	_ccvrefen = 1;
}

/********************************************************************
Function: fun_Dis_Analog_power
INPUT	:
OUTPUT	:
NOTE	:
********************************************************************/
void fun_Dis_Analog_power()
{
	_regc = 0;
	_pgaen = 0;	
	_ccvrefen = 0;	
	_batden = 0;
	_cpen = 0;	
	
	_pgac0 = 0;
	_pgac1 = 0;
	_pgac2 = 0;
	_pgac3 = 0;	
	_scfc0 = 0;
	_scfc1 = 0;
	_scfckd = 0;
	_ccvrefc = 0;	
}



/********************************************************************
Function: fun_en_battery_check
INPUT	:
OUTPUT	:
NOTE	:
********************************************************************/
void fun_en_battery_check()
{
	_batden = 1;
}
/********************************************************************
Function: fun_en_battery_check
INPUT	:
OUTPUT	:
NOTE	:
********************************************************************/
void fun_dis_battery_check()
{
	_batden = 0;
}


/********************************************************************
Function: fun_en_battery_check
INPUT	:
OUTPUT	:
NOTE	:
********************************************************************/
void fun_battery_check()
{
	volatile u16 	gu16v_battery_ad;
	fun_en_battery_check();
	GCC_DELAY(1000);
	gu16v_battery_ad = fun_Get_ADC(AN7)/16;
	gu16v_battery_ad = ((u32)gu16v_battery_ad*133)/256;//*3.3*13.3/(256*3.3);
	gu8v_battery_votage = (u8)gu16v_battery_ad;
	fun_dis_battery_check();	
	gu8v_battery_votage = gu16v_battery_ad;
	
	_stmal = 500%256;//;占空比
	_stmah = 500/256;	
	
	gu16v_pwm_target.u16 = 500;
	gu16v_pwm_buff.u16 = 500;				
}

/********************************************************************
Function: fun_en_battery_check
INPUT	:
OUTPUT	:
NOTE	: 測試
********************************************************************/
void ANALOG_TEST()
{
	fun_En_Analog_power();
	while(1)
	{
		
		GCC_CLRWDT();
		
		if(gbv_work_polling)
		{
			gbv_work_polling = 0;
			array_uart_txbuff[0]	= 0x55;	
			array_uart_txbuff[1]	= 00;			
			array_uart_txbuff[2]	= gu8a_PRESSURE_data_TEST%256;	
			array_uart_txbuff[3]	= gu8a_PRESSURE_data_TEST/256;	
			array_uart_txbuff[4]	= 0;		
			array_uart_txbuff[5]	= array_uart_txbuff[0]+array_uart_txbuff[1]+array_uart_txbuff[2]+array_uart_txbuff[3]+array_uart_txbuff[4];			
			_txr_rxr= array_uart_txbuff[0];					
			gu8v_tx_guide=0;
			
			
		}
		
	}

			
}
/********************************************************************
Function: SCF_TEST
INPUT	:
OUTPUT	:
NOTE	: 測試
********************************************************************/
void SCF_TEST()
{
	fun_En_Analog_power();
	_pbc2=0;
	while(1)
	{
		
		GCC_CLRWDT();
		//清除看門狗

		if(gbv_work_polling)//_ptm2af||
		{

			_pb2=~_pb2;
			//10ms 循環		
			gbv_work_polling = 0;
			UART_TX_MEASURING();
			
		}
		
//		UART_TX_MEASURING();
//		GCC_DELAY(60000);		
	}	
}
